/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package productsFinal;

import java.text.NumberFormat;
import java.util.Objects;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class Product extends Item {

    private final String name;
    private String brand;
    private Description description = new Description();
    private Colour colour;
    private double price;
    private int ID;
    private static int nextProductNumber =1;//Start the product number at 1

    //Constructors
//    public Product() {
//    }

    public Product(String name) {
        super(name);
        this.name=name;
        this.ID = nextProductNumber++;
    }

    public Product(String name, String description, double price) {
        this(name);
        enterDescription(description);
        setPrice(price);
    }

    public int getID() {
        return ID;
    }

    //Getter and Setter for colour
    public void setColour(String name) {
        this.colour = toColour(name); 
    }
    public String getColour() {
        return toName(this.colour);
    }

    public final void enterDescription(String comment, String country, int height, int weight) {
        this.description = new Description(comment, country, height, weight);
    }

    public final void enterDescription(String comment) {
        this.description = new Description(comment);
    }

    //This method will be used whenever anyone want to print out the details of a product.
    public void printProduct() {
        //Print out Name, Description and Price
        System.out.println("Name: " + getName());
        System.out.println("Description: " + getDescription());
        System.out.println("Price: " + getPrice());
    }

    public String getName() {
        return name;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    protected String getDescription() {
        return description.comments
                + " Country: " + description.country
                + " Height: " + description.height
                + " Weight: " + description.weight;
    }

    public String getPrice() {
        //Define our format as the default currency.
        NumberFormat defaultFormat = NumberFormat.getCurrencyInstance();
        
        //return the price in the default format.
        return defaultFormat.format(price);
    }

    public void setPrice(double price) {
            if (price >= 0) {
                this.price = price;
            } else {//Price is negative
                System.out.println("You can not enter a negative price.");
            }
    }
    
    @Override
    public String toString(){
        return "ID: "+ID
        +"\nName: " + getName()
        +"\nDescription: " + getDescription()
        +"\nPrice: " + getPrice();
    }
    
    @Override
    public boolean equals(Object o){
        if (o instanceof Product){
            return ((Product) o).name.equals(this.name);
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.name);
        return hash;
    }
    
        public static Colour toColour(String name) {
        switch (name) {
            case "Red": 
                return Colour.RED;
            case "Blue":
                return Colour.BLUE;
            case "Black":
                return Colour.BLACK;
            case "Green":
                return Colour.GREEN;
            default:
                System.out.println("The products colour must be either Red, Blue, Black or Green");
                return null;
        }
    }
    
    public static String toName(Colour colour){
        return colour.name;
    }
    
    public static int getNextProductNumber(){
        //print out the ID and name of the product first
//        System.out.println("Product ID: "+this.ID);
//        System.out.println("Name: "+this.getName());
        return nextProductNumber;
    }
    
    public static void resetNextProductNumber(){
        nextProductNumber = 1;
    }
    
}
